import controlP5.*;

ControlP5 controlP5;

int myColorBackground = color(0,0,0);

int knobValue = 100;

/**
 * oscP5broadcastClient by andreas schlegel
 * an osc broadcast client.
 * an example for broadcast server is located in the oscP5broadcaster exmaple.
 * oscP5 website at http://www.sojamo.de/oscP5
 */

import oscP5.*;
import netP5.*;

boolean ledState = false;

OscP5 oscP5;

/* a NetAddress contains the ip address and port number of a remote location in the network. */
NetAddress myBroadcastLocation; 

void setup() {
  size(400,100);
  smooth();
  controlP5 = new ControlP5(this);
  controlP5.addKnob("knob",0,255,0,15,15,60);
  
  oscP5 = new OscP5(this,12000);
  //myBroadcastLocation = new NetAddress("172.20.10.14",8888);
  //myBroadcastLocation = new NetAddress("192.168.1.100",8888);
  myBroadcastLocation = new NetAddress("192.168.188.100",8888);
}

void draw() {
  background(myColorBackground);
  fill(knobValue);
  rect(0,0,width,100);
}

void knob(int brightness) {  
  
  OscMessage myOscMessage = new OscMessage("/led");
  myOscMessage.add(brightness);
  oscP5.send(myOscMessage, myBroadcastLocation);   
  
  
}



/* incoming osc message are forwarded to the oscEvent method. */
void oscEvent(OscMessage theOscMessage) {
  /* get and print the address pattern and the typetag of the received OscMessage */
  println("### received an osc message with addrpattern "+theOscMessage.addrPattern()+" and typetag "+theOscMessage.typetag());
  theOscMessage.print();
}
