#include "Arduino.h"
#include "WiFi.h"
#include <OSCMessage.h>

IPAddress staticIP(192, 168, 188, 100); // ESP32 static IP
IPAddress gateway(192, 168, 188, 1);    // IP Address of your network gateway (router)
IPAddress subnet(255, 255, 255, 0);   // Subnet mask
IPAddress primaryDNS(192, 168, 188, 1); // Primary DNS (optional)
IPAddress secondaryDNS(0, 0, 0, 0);   // Secondary DNS (optional)

WiFiUDP Udp; // A UDP instance to let us send and receive packets over UDP
int LED_PIN = 5;

// Options
int update_rate = 16;

// Network settings
char ssid[] = "Oben"; // your network SSID (name)
char pass[] = "topsecret123";  // your network password
unsigned int localPort = 8888; // local port to listen for OSC packets

void setup() {
  //Serial.begin( 115200 );
  pinMode(LED_PIN, OUTPUT);

 // Configuring static IP
  if(!WiFi.config(staticIP, gateway, subnet, primaryDNS, secondaryDNS)) {
    //Serial.println("Failed to configure Static IP");
  } else {
    //Serial.println("Static IP configured:");
  }  

  /* setup wifi */
  WiFi.begin(ssid, pass);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    //Serial.print(".");
  }



  //Serial.println(WiFi.localIP());

  Udp.begin(localPort);
}

void ledtoggle(OSCMessage &msg) {
  int value = msg.getInt(0);
  //Serial.println( value );
  analogWrite(LED_PIN, value);
}

void receiveMessage() {
  OSCMessage inmsg;
  int size = Udp.parsePacket();

  if (size > 0) {
    while (size--) {
      inmsg.fill(Udp.read());
    }
    if (!inmsg.hasError()) {
      inmsg.dispatch("/led", ledtoggle);
    } 
    //else { auto error = inmsg.getError(); }
  }
}

void loop() {
  receiveMessage();
  delay(update_rate);
}
